/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.tree.species;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.leaves.PalmLeavesProperties;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKits;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.family.MangroveFamily;
import com.ferreusveritas.dynamictrees.tree.family.PalmFamily;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.mojang.datafixers.util.Function3;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;

public class PalmSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = PalmSpecies.createDefaultType((Function3<ResourceLocation, Family, LeavesProperties, Species>)((Function3)PalmSpecies::new));

    public PalmSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
        if (!(family instanceof MangroveFamily)) {
            LogManager.getLogger().warn("Family " + family.getRegistryName() + " for palm species " + this.getRegistryName() + " is not of type " + PalmFamily.class);
        }
        if (!(leavesProperties instanceof PalmLeavesProperties)) {
            LogManager.getLogger().warn("LeavesProperties " + leavesProperties.getRegistryName() + " for palm species " + this.getRegistryName() + " is not of type " + PalmLeavesProperties.class);
        }
        this.setGrowthLogicKit(GrowthLogicKits.PALM);
    }

    @Override
    public boolean postGrow(Level level, BlockPos rootPos, BlockPos treePos, int fertility, boolean natural) {
        BlockState trunkBlockState = level.m_8055_(treePos);
        BranchBlock branch = TreeHelper.getBranch(trunkBlockState);
        if (branch == null) {
            return false;
        }
        FindEndsNode endFinder = new FindEndsNode();
        MapSignal signal = new MapSignal(endFinder);
        branch.analyse(trunkBlockState, (LevelAccessor)level, treePos, Direction.DOWN, signal);
        List<BlockPos> endPoints = endFinder.getEnds();
        for (BlockPos endPoint : endPoints) {
            TreeHelper.ageVolume((LevelAccessor)level, endPoint, 2, 3, 3, SafeChunkBounds.ANY);
        }
        int radius = branch.getRadius(level.m_8055_(treePos.m_7494_()));
        if (radius != 0) {
            branch.setRadius((LevelAccessor)level, treePos, radius + 1, null);
        }
        return super.postGrow(level, rootPos, treePos, fertility, natural);
    }

    @Override
    protected boolean transitionToTree(Level level, BlockPos pos, Family family) {
        family.getBranch().ifPresent(branch -> branch.setRadius((LevelAccessor)level, pos, family.getPrimaryThickness(), null));
        level.m_46597_(pos.m_7494_(), (BlockState)this.getLeavesProperties().getDynamicLeavesState().m_61124_((Property)DynamicLeavesBlock.f_54418_, (Comparable)Integer.valueOf(4)));
        level.m_46597_(pos.m_6630_(2), (BlockState)this.getLeavesProperties().getDynamicLeavesState().m_61124_((Property)DynamicLeavesBlock.f_54418_, (Comparable)Integer.valueOf(3)));
        this.placeRootyDirtBlock((LevelAccessor)level, pos.m_7495_(), 15);
        return true;
    }

    @Override
    public void postGeneration(PostGenerationContext context) {
        LevelAccessor level = context.level();
        for (BlockPos endPoint : context.endPoints()) {
            BlockPos tip = endPoint.m_6630_(2);
            if (!(level.m_8055_(tip).m_60734_() instanceof DynamicLeavesBlock)) continue;
            for (CoordUtils.Surround surr : CoordUtils.Surround.values()) {
                BlockPos leafPos = tip.m_121955_(surr.getOffset());
                BlockState leafState = level.m_8055_(leafPos);
                Block block = leafState.m_60734_();
                if (!(block instanceof DynamicLeavesBlock)) continue;
                DynamicLeavesBlock block2 = (DynamicLeavesBlock)block;
                level.m_7731_(leafPos, block2.getLeavesBlockStateForPlacement(level, leafPos, leafState, (Integer)leafState.m_61143_((Property)LeavesBlock.f_54418_), true), 2);
            }
        }
        super.postGeneration(context);
    }

    @Override
    @Nullable
    public HashMap<BlockPos, BlockState> getFellingLeavesClusters(BranchDestructionData destructionData) {
        int endPointsNum = destructionData.getNumEndpoints();
        if (endPointsNum < 1) {
            return null;
        }
        HashMap<BlockPos, BlockState> leaves = new HashMap<BlockPos, BlockState>();
        for (int i = 0; i < endPointsNum; ++i) {
            BlockPos relPos = destructionData.getEndPointRelPos(i).m_6630_(2);
            relPos = relPos.m_7495_();
            LeavesProperties leavesProperties = destructionData.species.getLeavesProperties();
            HashSet<BlockPos> existingLeaves = new HashSet<BlockPos>();
            for (int j = 0; j < destructionData.getNumLeaves(); ++j) {
                existingLeaves.add(destructionData.getLeavesRelPos(j));
            }
            if (existingLeaves.contains(relPos)) {
                leaves.put(relPos, leavesProperties.getDynamicLeavesState(4));
            }
            if (existingLeaves.contains(relPos.m_7494_())) {
                leaves.put(relPos.m_7494_(), leavesProperties.getDynamicLeavesState(3));
            }
            for (int hydro = 1; hydro <= 2; ++hydro) {
                BlockState state = leavesProperties.getDynamicLeavesState(hydro);
                for (CoordUtils.Surround surr : PalmLeavesProperties.DynamicPalmLeavesBlock.hydroSurroundMap[hydro]) {
                    BlockPos leafPos = relPos.m_7494_().m_121955_(surr.getOpposite().getOffset());
                    if (!existingLeaves.contains(leafPos)) continue;
                    leaves.put(leafPos, PalmLeavesProperties.DynamicPalmLeavesBlock.getDirectionState(state, surr));
                }
            }
        }
        return leaves;
    }
}

